<?php

$baseUrl = 'https://www.jamesedition.com/real_estate/all?eur_price_cents_from=116590800&eur_price_cents_to=1231200000&property_feature_ids[]=34&property_feature_ids[]=7&page=';
$name = "test"; 
$outputFile = 'listing_' . $name . '.txt'; 
file_put_contents($outputFile, ""); // Clear the file before starting

function fetchPageWithCurl($url) {
    $ch = curl_init();

    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_TIMEOUT => 15,
        CURLOPT_SSL_VERIFYPEER => true,
        CURLOPT_SSL_VERIFYHOST => 2,
        CURLOPT_ENCODING => '',
        CURLOPT_USERAGENT => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/115.0.0.0 Safari/537.36',
        CURLOPT_HTTPHEADER => [
            'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
            'Accept-Language: en-US,en;q=0.9',
            'Connection: keep-alive',
            'Upgrade-Insecure-Requests: 1',
        ],
    ]);

    $html = curl_exec($ch);

    if (curl_errno($ch)) {
        echo "cURL error on $url: " . curl_error($ch) . "\n";
        curl_close($ch);
        return false;
    }

    curl_close($ch);
    return $html;
}

for ($page = 2; $page <= 2; $page++) {
    $url = $baseUrl . $page;
    //echo "Fetching: $url\n";

    //$html = fetchPageWithCurl($url);
    //$html = mycurl($url);
    
    $file = "webpage_output_" . $name . ".txt"; 
    $html = file_get_contents($file);
    if (!$html) {
        echo "Failed to fetch page $page\n";
        continue;
    }
    //echo $html; die; 
    $t = explode("ListingCard _ar", $html);
    echo  "TheCOUNT=" . " " . count($t);  

    foreach ($t as $tmatch) {
        $price = get_string_between($tmatch, 'data-price-usd="', '"');
        echo $price . "<br/>PRIX= ";
        if ($price !== "ZZ"){
            $country = get_string_between($tmatch, 'data-country="', '"');
            $href = get_string_between($tmatch, 'href="', '"');
            $title = get_string_between($tmatch, 'title="', '"');
            $bedroom = get_string_between($tmatch, '"numberOfBedrooms": "', '"');
            $type = get_string_between($tmatch, '"accommodationCategory": "', '"');
            //$sqm = get_string_rev_between($tmatch, '>', 'sqm');
            $line = "$country | $price | $sqm | $type | $bedroom | $href  | $title\n"; 
            file_put_contents($outputFile, $line, FILE_APPEND); 
        } 
    }    


    sleep(1); // Be polite to the server
}

echo "✅ Done. Data saved to: $outputFile\n";

function get_string_between($string, $start, $end){
    $string = " ".$string;
    $ini = strpos($string,$start);
    if ($ini == 0) return "ZZ";
    $ini += strlen($start);
    $len = strpos($string,$end,$ini) - $ini;
    return substr($string,$ini,$len);
} 
function get_string_rev_between($string, $start, $end){
    $string = " ".$string;
    $ini = strpos($string,$end);
    if ($ini == 0) return "ZZ";
    for ($i = 1; $i < 20; $i++){
        $x = strpos($string,$start, $ini -$i);
        if ($x != 0){
            $len = strlen($start);
            return substr($string,$x + $len,$ini - $x -$len);           
        }
    }

    $ini += strlen($start);
    $len = strpos($string,$end,$ini) - $ini;
    return substr($string,$ini,$len);
}

function mycurl($url){
$target = "http://base.be-villa.com/rd/curl/proxycurl.php";
$target = "http://tk-node-uk.baliluxuryvillas.com/proxycurl.php";
$target = "http://tk-node.baliluxuryvillas.com/curl/proxycurl.php";  //This one seems better (more reliable) than UK
$target = "http://contabousa.baliluxuryvillas.com/curl/proxycurl.php";  //Since 09/02/2024
$target = "http://tk-node.baliluxuryvillas.com/curl/proxycurl.php";
$ch = curl_init();

curl_setopt($ch, CURLOPT_URL,$target);
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS,
            "URL=" . urlencode($url));

// In real life you should use something like:
// curl_setopt($ch, CURLOPT_POSTFIELDS, 
//          http_build_query(array('postvar1' => 'value1')));

// Receive server response ...
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

$server_output = curl_exec($ch);

//echo "MYCURL " . $url . "\n" . $server_output; die; 

curl_close ($ch);
return $server_output;
}

?>